/*********************************************************************************
Exercice 21 :

PART 1

rcursivit et pile, visualiser le dplacement
des anneaux des tours de Hano
L'objectif est d'crire un programme pour visualiser l'algorithme des tours de Hano
et pour un nombre n d'anneaux avec n >= 3. La rcursivit devra tre limine via
l'utilisation de piles, une pile par poteau. Les anneaux sont reprsents par des
entiers qui donnent la taille de l'anneau.
Avant de commencer :
		Pourquoi un poteau peut-il se reprsenter par une pile ?
		Dessiner larbre dappels de la procdure Hanoi pour n=3.
		Avec votre arbre dappels, donner lordre de dplacement de chaque anneau tel
		que visualis dans le printf de la procdure Hanoi.

PART 2

Reprendre la procdure Hanoi mais en reprsentant chaque tour par une pile. Le dplacement
visuel du printf sera remplac par un dplacement effectif dun anneau entre deux piles
(tours).
1) crire une fonction qui affiche le contenu d'une pile danneaux (1 anneau = 1 entier).
2) Dclarer trois piles qui reprsentent les trois poteaux du jeu, et crire une fonction
qui initialise le jeu en empilant les n anneaux correctement sur l'un des trois poteaux.
crire galement une fonction qui affiche  l'cran l'tat du jeu  un instant donn.
3) crire une fonction qui dplace les n anneaux sur l'un des deux poteaux libres en
respectant les rgles du jeu. Faire en sorte que l'affichage  l'cran montre bien le
dplacement de chaque anneau.
**********************************************************************************/

// PART 1

#include <stdio.h>
#include <stdlib.h>

int	SaisieNombre(void);
void Deplacement(int n, int d, int i, int a);
void Hanoi(int n, int d, int i, int a);

/*******************************************************************************
*******************************************************************************/
int main()
{
	int n = 0;
	while (n>=0) {

		printf("(nombre negatif pour quitter)\n");
		n = SaisieNombre();
		Deplacement(n, '1', '2', '3');

	}
}
/*******************************************************************************
saisie nombre de disques par utilisateur
*******************************************************************************/
int SaisieNombre()
{
	int res = 0, n;
	printf ("nombre de disques : ");
	do{
		if((res = scanf_s("%d", &n)) == 0)
			printf("entree incorrecte\n");
		rewind(stdin);
	}while (!res);
	
	putchar('\n');
	return n;
}
/***************************************************************************
Soit trois variables D, I et A qui reprsentent trois piquets Dpart,
Intermdiaire et Arrive. Ces piquets restent fixes. les valeurs correspondent
aux plateaux et aux permutations des dplacements.

l'algorithme est le suivant :

au dpart le premier en D va en arrive A, c'est l'appel initial :
deplacement (N, D,I,A)    [avec N=3]

	1) les n-1 restants au dpart en D sont mis sur I en arrive
	(A devient intermdiaire) c'est l'appel rcursif:
	-> deplacement (N-1, D, A, I)  [avec N = 2 puis N = 1 puis N = 0,  chaque fois I et A sont permuts]

	2) Le dernier au dpart en D est mis sur arrive en A (I intermdiaire ne bouge pas)
	[Pour N = 0 les appels rcursifs cessent et la pile des appels prcdents est dpiles. 
	Pour N = 1 en remontant c'est l'instruction printf qui met le dernier au dpart en D sur arrive en A]
	-> printf deplacement D vers A

	[Ensuite les appels rcursifs explorent la seconde branche de dplacement.]
	3) Les n-1 au dpart de intermdiaire sont mis sur A en arrive
	(D devient intermdiaire)
	-> deplacement (N-1, I, D, A)
	[Pour N=1 l'appel se fait avec N=0 et il ne se passe plus rien. La suite reprend avec le dpilement
	 N=2. L c'est l'instruction printf deplacement D vers A et la redescente avec N=1 en inversant D et I]


Voici l'arbre d'appels pour N = 3
												DIA
											N=3,123
											 4) 13
						DAI												IDA
					N=2 132											N=2 213
					 2) 12											6) 23
		DAI							IDA					DAI							IDA
	N=1 123						N=1 312				N=1 231						N=1 123
	N=0 fin						N=0 fin				N=0 fin						N=0 fin
  1)N=1 13					  3)N=1 32			  5)N=1 21					  7)N=1 13

  Vous pouvez regarder au dbogueur la pile des appels et constater empilements et dpilements 
  des appels rcursifs de la fonction Hanoi (rebaptise "dplacement" ci-dessous)
*****************************************************************************************/
void Deplacement(int n, int d, int i, int a)
{
	if (n > 0) {
		Deplacement(n - 1, d, a, i);
		printf("n%d = d%c, i%c, a%c : dep %c - %c\n", n, d, i, a, d, a);
		Deplacement(n - 1, i, d, a);
	}
}
/*******************************************************************************
Autre version peut-tre plus parlante. Ne pas hsiter  regarder le fonctionnement
au dbogueur
*******************************************************************************/
void Hanoi(int n, int d, int i, int a)
{
	if (n == 1)				// afficher le dplacement de chaque dernier
		printf("aller de %c en %c\n", d, a);
	else {
		Hanoi(n - 1, d, a, i); // dplacer les n-1 anneaux de dpart en intermdiaire
		Hanoi(1, d, i, a);	// deplacer le dernier de dpart sur arrive
		Hanoi(n - 1, i, d, a); // deplacer les n-1 anneaux de intermdiaire en arrive
	}
}
/*******************************************************************************
*******************************************************************************/


